package gov.va.med.mhv.sm.api.transfer;

import gov.va.med.mhv.sm.enumeration.MessageCategoryTypeEnum;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.http.client.utils.DateUtils;

@XmlRootElement(name = "Message")
public abstract class MessageTO implements Serializable {
	public static final long serialVersionUID = -5445747007234726972L;

	private Long id;
	private MessageCategoryTypeEnum category;
	private String subject;
	private String body;
	private boolean attachment;
	private AttachmentsTO attachments;
	private Date sentDate;
	private Long senderId;
	private String senderName;
	private Long recipientId;
	private String recipientName;
	private String readReceipt;


	public MessageTO() {
	}

	public MessageTO(long id, MessageCategoryTypeEnum category, String subject,
			String body, boolean attachment, AttachmentsTO attachments, Long senderId, String senderName, Long recipientId, String recipientName, Date sentDate, String readReceipt) {
		this.id = id;
		this.category = category;
		this.subject = subject;
		this.body = body;
		this.attachment = attachment;
		this.attachments = attachments;
		this.senderId = senderId;
		this.senderName = senderName;
		this.recipientId = recipientId;
		this.recipientName = recipientName;
		this.sentDate = sentDate;
		this.readReceipt = readReceipt;
	}

	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public MessageCategoryTypeEnum getCategory() {
		return category;
	}
	public void setCategory(MessageCategoryTypeEnum category) {
		this.category = category;
	}
	public String getBody() {
		return body;
	}
	public void setBody(String body) {
		this.body = body;
	}
	public String getSubject() {
		return subject;
	}
	public void setSubject(String subject) {
		this.subject = subject;
	}
	public boolean isAttachment() {
		return attachment;
	}
	public void setAttachment(boolean attachment) {
		this.attachment = attachment;
	}
	public AttachmentsTO getAttachments() {
		return attachments;
	}
	public void setAttachments(AttachmentsTO attachments) {
		this.attachments = attachments;
	}
	public String getSentDate() {
		//For DRAFT messages there is a null date
		return (sentDate!=null?DateUtils.formatDate(sentDate):"");
	}
	public void setSentDate(Date sentDate) {
		this.sentDate = sentDate;
	}
	public Long getSenderId() {
		return senderId;
	}
	public void setSenderId(Long senderId) {
		this.senderId = senderId;
	}
	public String getSenderName() {
		return senderName;
	}
	public void setSenderName(String senderName) {
		this.senderName = senderName;
	}
	public Long getRecipientId() {
		return recipientId;
	}
	public void setRecipientId(Long recipientId) {
		this.recipientId = recipientId;
	}
	public String getRecipientName() {
		return recipientName;
	}
	public void setRecipientName(String recipientName) {
		this.recipientName = recipientName;
	}
	public String getReadReceipt() {
		return readReceipt;
	}
	public void setReadReceipt(String readReceipt) {
		this.readReceipt = readReceipt;
	}

	public String toString() {
		return "id="+id+
		";category="+category+
		";subject="+subject+
		";body="+body+
		";attachment="+attachment+
		";attachments="+attachments+
		";sentDate="+sentDate+
		";senderId="+senderId +
		";senderName="+senderName +
		";recipientId="+recipientId +
		";recipientName="+recipientName+
		";readReceipt="+readReceipt;
	}
}
